package EarnixParser;

import java.util.ArrayList;
import java.util.List;

public class EarnixStruct extends Object {
	public EarnixStruct(String name, EarnixStruct pStruct) {
		this.name = name;
		this.parentStruct = pStruct;
		subitems = new ArrayList<EarnixStruct>();
		attributeList = new ArrayList<EarnixAttribute>();
	}

	String name;
	EarnixStruct parentStruct;
	List< EarnixAttribute> attributeList;
	List<EarnixStruct> subitems;

	public void addSubitem(EarnixStruct newEarnixStruct) {
		subitems.add( newEarnixStruct);
	}

	public void addAttributeKey(String attributeName) {
		attributeList.add( new EarnixAttribute( attributeName));
	}
	
	public List<EarnixAttribute> getAttributeList(){
		return attributeList;
	}
	
	public String toString() {
		return getName();
	}

	public String getPath() {
		if( parentStruct == null)
			return name;
		else
			return parentStruct.toString() + "/" + name;
	}

	public String getName() {
		return name;
	}

	public List<EarnixStruct>getSubItems() {
		return subitems;
	}
	
	public void setValue( int index, String value) {
		attributeList.get(index).setValue(value);
	}

	public int getAttributeCount( ) {
		return attributeList.size();
	}

	public EarnixStruct createNewInstance( EarnixStruct parentStruct) {
		// create new
		// assgin name
		// assign parent item
		EarnixStruct newInstance = new EarnixStruct(name, parentStruct);

		// create attributes and values
		for( EarnixAttribute attribute : attributeList) {
			newInstance.addAttributeKey( attribute.getKey());
		}
		
		return newInstance;
	}
}
