package EarnixParser;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

public class EarnixStructTableModel extends AbstractTableModel{
	/**
	 * 
	 */
	private static final long serialVersionUID = -912359235787847266L;
	List< List<String>> transformedEarnixStruct;
	String[] headerLabels;
	
	public EarnixStructTableModel( EarnixStruct rootStruct){
		transformedEarnixStruct = new ArrayList< List<String>>();
		headerLabels = new String[] { "Path", "Id", "Value"};
		
		parseRootRecursively( rootStruct);
		
		// only debug, print all values
/*
  		for( List<String> list : transformedEarnixStruct) {
 
			System.out.println( "ITEM\t" + list.get( 0) + "\t" + list.get( 1) + "\t" + list.get( 2));
		}
*/
		
		System.out.println( "transformedEarnixStruct count " + transformedEarnixStruct.size());
	}
	
	private void parseRootRecursively( EarnixStruct earnixStruct) {
		for( int index = 0; index < earnixStruct.getAttributeList().size(); index++) {
			List<String> newTableRow = new ArrayList<String>();
			transformedEarnixStruct.add( newTableRow);

			newTableRow.add( earnixStruct.toString());
			newTableRow.add( earnixStruct.getAttributeList().get(index).getKey());
			newTableRow.add( earnixStruct.getAttributeList().get(index).getValue());
		}
		
		// do the same for each subitem
		for( EarnixStruct childStruct : earnixStruct.getSubItems()){
			parseRootRecursively( childStruct);
		}
	}

	@Override
	public int getRowCount() {
		return transformedEarnixStruct.size();
	}

	@Override
	public int getColumnCount() {
		return 3;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		return transformedEarnixStruct.get( rowIndex).get(columnIndex);
	}
	
    @Override
    public String getColumnName(int column) {
        return headerLabels[ column];
    }
}
