import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import EarnixParser.EarnixStruct;
import EarnixParser.EarnixStructTableModel;
import TreeTable.*;

import javax.swing.JTextArea;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.JTree;
import javax.swing.SwingConstants;
import javax.swing.JLabel;
import javax.swing.JTextField;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.InputMethodEvent;
import javax.swing.JRadioButton;
import javax.swing.Box;

public class MainWindow {

	private JFrame frame;
	private JTextArea txtInput1;
	private JSplitPane splitPane;
	HashMap<Integer, BalickyDataNode> structMap;
	private JTable table;
	private EarnixStruct rootEarnixAttributeStruct;
	private EarnixStruct rootEarnixValueStruct;
	private String tabulator;
	private JTextField filterText;

	private List<Integer> filterRowsFound;
	private Integer filterRowsCurrentIndex;
	private JLabel filterCountIndicator;
	private MyTreeTable earnixTreeTable;
	private JRadioButton filterNazevCheck;
	private JRadioButton filterHodnotaCheck;
	
	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainWindow window = new MainWindow();
					window.frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainWindow() {
		initialize();
	}

	void filterNext() {
		if( filterRowsCurrentIndex + 1 < filterRowsFound.size()) {
			filterRowsCurrentIndex++;
			filterUpdate();
		}
	}
	
	void filterPrev() {
		if( filterRowsCurrentIndex > 0) {
			filterRowsCurrentIndex--;
			filterUpdate();
		}
	}

	void filterUpdate() {
		filterCountIndicator.setText( filterRowsFound.size()==0?"-":String.valueOf( filterRowsCurrentIndex + 1) + "/" + String.valueOf( filterRowsFound.size()));
		
		if(filterRowsCurrentIndex >= 0 && filterRowsFound.size() > 0) {
			earnixTreeTable.expandAll();
			earnixTreeTable.setRowSelectionInterval( filterRowsFound.get( filterRowsCurrentIndex), filterRowsFound.get( filterRowsCurrentIndex));
			earnixTreeTable.scrollRectToVisible(new Rectangle(earnixTreeTable.getCellRect(filterRowsFound.get( filterRowsCurrentIndex), 0, true)));
		}
	}


	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		filterRowsFound = new ArrayList<Integer>();
		filterRowsCurrentIndex = -1;
		frame = new JFrame();
		tabulator = "";
		frame.setBounds(100, 100, 800, 600);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), BoxLayout.Y_AXIS));

		JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);
		frame.getContentPane().add(tabbedPane);

		JPanel paneBalicky = new JPanel();
		paneBalicky.setLayout(new BoxLayout(paneBalicky, BoxLayout.Y_AXIS));
		
		JButton btnNewButton = new JButton("New button");
		paneBalicky.add(btnNewButton);

		txtInput1 = new JTextArea();
		txtInput1.setLineWrap(true);
		txtInput1.setWrapStyleWord(true);
		txtInput1.setText("<ns5:vypocetPojistneho xmlns:ns5=\"http://csobpoj.cz/esb/premiumcalculation/PremiumCalculationServiceBal/v1.0\"><ns5:transakceVypoctu><ns5:cisloPs>6154843519</ns5:cisloPs><ns5:cisloDodatku>0</ns5:cisloDodatku><ns5:transakceId>1</ns5:transakceId><ns5:typTransakce>1</ns5:typTransakce><ns5:stavVypoctu>CEKA_NA_VYPOCET</ns5:stavVypoctu><ns5:popisChyby></ns5:popisChyby><ns5:parametry><ns5:parametr><ns5:nazev>C_SPOLUPRAC</ns5:nazev><ns5:hodnota>8100588</ns5:hodnota></ns5:parametr><ns5:parametr><ns5:nazev>CON_UZIV_LOGIN</ns5:nazev><ns5:hodnota>cermakp</ns5:hodnota></ns5:parametr><ns5:parametr><ns5:nazev>CON_UZIV_HEC</ns5:nazev><ns5:hodnota>2110486</ns5:hodnota></ns5:parametr><ns5:parametr><ns5:nazev>druhTransakce</ns5:nazev><ns5:hodnota>0</ns5:hodnota></ns5:parametr><ns5:parametr><ns5:nazev>TYPOVANE_POJISTNE</ns5:nazev><ns5:hodnota>false</ns5:hodnota></ns5:parametr></ns5:parametry><ns5:struktury><ns5:struktura><ns5:id>1</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cStruktura>1</ns5:cStruktura></ns5:struktura><ns5:struktura><ns5:id>2</ns5:id><ns5:poradiStruktury>2</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>1</ns5:poradiNadrazeneStruktury><ns5:cStruktura>4</ns5:cStruktura><ns5:osobaId>10</ns5:osobaId></ns5:struktura><ns5:struktura><ns5:id>3</ns5:id><ns5:poradiStruktury>3</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>1</ns5:poradiNadrazeneStruktury><ns5:cStruktura>4</ns5:cStruktura><ns5:osobaId>11</ns5:osobaId></ns5:struktura><ns5:struktura><ns5:id>4</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>1</ns5:poradiNadrazeneStruktury><ns5:cStruktura>4</ns5:cStruktura><ns5:osobaId>12</ns5:osobaId></ns5:struktura><ns5:struktura><ns5:id>5</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>1</ns5:poradiNadrazeneStruktury><ns5:cStruktura>8</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId></ns5:struktura><ns5:struktura><ns5:id>6</ns5:id><ns5:poradiStruktury>6</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>11</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni></ns5:struktura><ns5:struktura><ns5:id>7</ns5:id><ns5:poradiStruktury>7</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>1</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>8</ns5:id><ns5:poradiStruktury>8</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>3</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>9</ns5:id><ns5:poradiStruktury>9</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>4</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>10</ns5:id><ns5:poradiStruktury>10</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>5</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>11</ns5:id><ns5:poradiStruktury>11</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>7</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>12</ns5:id><ns5:poradiStruktury>12</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>8</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>13</ns5:id><ns5:poradiStruktury>13</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>9</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>14</ns5:id><ns5:poradiStruktury>14</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>10</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>15</ns5:id><ns5:poradiStruktury>15</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>11</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>16</ns5:id><ns5:poradiStruktury>16</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>19</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>17</ns5:id><ns5:poradiStruktury>17</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>45</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>18</ns5:id><ns5:poradiStruktury>18</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>46</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>19</ns5:id><ns5:poradiStruktury>19</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:dejId>271</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>20</ns5:id><ns5:poradiStruktury>20</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>6</ns5:poradiNadrazeneStruktury><ns5:cStruktura>12</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>80</ns5:kodPojisteni><ns5:slevaId>3</ns5:slevaId></ns5:struktura><ns5:struktura><ns5:id>21</ns5:id><ns5:poradiStruktury>21</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>11</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>81</ns5:kodPojisteni></ns5:struktura><ns5:struktura><ns5:id>22</ns5:id><ns5:poradiStruktury>22</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>21</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>81</ns5:kodPojisteni><ns5:dejId>13</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>23</ns5:id><ns5:poradiStruktury>23</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>21</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>81</ns5:kodPojisteni><ns5:dejId>21</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>24</ns5:id><ns5:poradiStruktury>24</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>21</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>81</ns5:kodPojisteni><ns5:dejId>60</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>25</ns5:id><ns5:poradiStruktury>25</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>21</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>81</ns5:kodPojisteni><ns5:dejId>61</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>26</ns5:id><ns5:poradiStruktury>26</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>21</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>81</ns5:kodPojisteni><ns5:dejId>62</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>27</ns5:id><ns5:poradiStruktury>27</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>21</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>81</ns5:kodPojisteni><ns5:dejId>63</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>28</ns5:id><ns5:poradiStruktury>28</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>21</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>81</ns5:kodPojisteni><ns5:dejId>64</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>29</ns5:id><ns5:poradiStruktury>29</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>21</ns5:poradiNadrazeneStruktury><ns5:cStruktura>12</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>81</ns5:kodPojisteni><ns5:slevaId>4</ns5:slevaId></ns5:struktura><ns5:struktura><ns5:id>30</ns5:id><ns5:poradiStruktury>30</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>11</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>84</ns5:kodPojisteni></ns5:struktura><ns5:struktura><ns5:id>31</ns5:id><ns5:poradiStruktury>31</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>30</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>84</ns5:kodPojisteni><ns5:dejId>16</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>32</ns5:id><ns5:poradiStruktury>32</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>11</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>83</ns5:kodPojisteni></ns5:struktura><ns5:struktura><ns5:id>33</ns5:id><ns5:poradiStruktury>33</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>32</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>83</ns5:kodPojisteni><ns5:dejId>105</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>34</ns5:id><ns5:poradiStruktury>34</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>32</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>83</ns5:kodPojisteni><ns5:dejId>106</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>35</ns5:id><ns5:poradiStruktury>35</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>32</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>83</ns5:kodPojisteni><ns5:dejId>107</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>36</ns5:id><ns5:poradiStruktury>36</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>11</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>137</ns5:kodPojisteni></ns5:struktura><ns5:struktura><ns5:id>37</ns5:id><ns5:poradiStruktury>37</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>36</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>137</ns5:kodPojisteni><ns5:dejId>276</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>38</ns5:id><ns5:poradiStruktury>38</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>36</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>137</ns5:kodPojisteni><ns5:dejId>277</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>39</ns5:id><ns5:poradiStruktury>39</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>11</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>85</ns5:kodPojisteni></ns5:struktura><ns5:struktura><ns5:id>40</ns5:id><ns5:poradiStruktury>40</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>39</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>85</ns5:kodPojisteni><ns5:dejId>14</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>41</ns5:id><ns5:poradiStruktury>41</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>11</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>86</ns5:kodPojisteni></ns5:struktura><ns5:struktura><ns5:id>42</ns5:id><ns5:poradiStruktury>42</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>41</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>86</ns5:kodPojisteni><ns5:dejId>17</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>43</ns5:id><ns5:poradiStruktury>43</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>11</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>170</ns5:kodPojisteni></ns5:struktura><ns5:struktura><ns5:id>44</ns5:id><ns5:poradiStruktury>44</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>43</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>170</ns5:kodPojisteni><ns5:dejId>325</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>45</ns5:id><ns5:poradiStruktury>45</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>11</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>87</ns5:kodPojisteni></ns5:struktura><ns5:struktura><ns5:id>46</ns5:id><ns5:poradiStruktury>46</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>45</ns5:poradiNadrazeneStruktury><ns5:cStruktura>13</ns5:cStruktura><ns5:predmetId>4</ns5:predmetId><ns5:kodPojisteni>87</ns5:kodPojisteni><ns5:dejId>18</ns5:dejId></ns5:struktura><ns5:struktura><ns5:id>47</ns5:id><ns5:poradiStruktury>47</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>20</ns5:cStruktura><ns5:osobaId>10</ns5:osobaId><ns5:predmetId>4</ns5:predmetId></ns5:struktura><ns5:struktura><ns5:id>48</ns5:id><ns5:poradiStruktury>48</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>20</ns5:cStruktura><ns5:osobaId>11</ns5:osobaId><ns5:predmetId>4</ns5:predmetId></ns5:struktura><ns5:struktura><ns5:id>49</ns5:id><ns5:poradiStruktury>49</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>5</ns5:poradiNadrazeneStruktury><ns5:cStruktura>20</ns5:cStruktura><ns5:osobaId>12</ns5:osobaId><ns5:predmetId>4</ns5:predmetId></ns5:struktura><ns5:struktura><ns5:id>50</ns5:id><ns5:poradiStruktury>50</ns5:poradiStruktury><ns5:poradiNadrazeneStruktury>1</ns5:poradiNadrazeneStruktury><ns5:cStruktura>12</ns5:cStruktura><ns5:slevaId>5</ns5:slevaId></ns5:struktura></ns5:struktury><ns5:policka><ns5:pole><ns5:id>0</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cisloPole>8</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>114</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>1</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cisloPole>18</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>2</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cisloPole>1119</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>3</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cisloPole>953</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>4</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cisloPole>14</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>5</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cisloPole>946</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>183822</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>6</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cisloPole>943</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>7</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cisloPole>12</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>6154843519.0000000000000000000</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>8</ns5:id><ns5:poradiStruktury>1</ns5:poradiStruktury><ns5:cisloPole>13</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-17T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>9</ns5:id><ns5:poradiStruktury>2</ns5:poradiStruktury><ns5:cisloPole>33</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>Nepov\u00EDm</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>10</ns5:id><ns5:poradiStruktury>2</ns5:poradiStruktury><ns5:cisloPole>149</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>9598</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>11</ns5:id><ns5:poradiStruktury>2</ns5:poradiStruktury><ns5:cisloPole>34</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>Ji\u0159\u00ED</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>12</ns5:id><ns5:poradiStruktury>2</ns5:poradiStruktury><ns5:cisloPole>32</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>8504254022</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>13</ns5:id><ns5:poradiStruktury>2</ns5:poradiStruktury><ns5:cisloPole>949</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1799</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>14</ns5:id><ns5:poradiStruktury>2</ns5:poradiStruktury><ns5:cisloPole>40</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>53002</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>15</ns5:id><ns5:poradiStruktury>2</ns5:poradiStruktury><ns5:cisloPole>941</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>2</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>16</ns5:id><ns5:poradiStruktury>3</ns5:poradiStruktury><ns5:cisloPole>941</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>7</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>17</ns5:id><ns5:poradiStruktury>3</ns5:poradiStruktury><ns5:cisloPole>949</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1799</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>18</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>34</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>Ji\u0159\u00ED</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>19</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>32</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>8504254022</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>20</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>33</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>Nepov\u00EDm</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>21</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>149</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>9598</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>22</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>941</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>8</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>23</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>81</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>10</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>24</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>668</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>25</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>662</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1985</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>26</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>949</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1799</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>27</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>40</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>53002</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>28</ns5:id><ns5:poradiStruktury>4</ns5:poradiStruktury><ns5:cisloPole>880</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>29</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>61</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>11</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>30</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>57</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>31</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>664</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1799</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>32</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>66</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2011-01-01T00:00:00.000+01:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>33</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>62</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>970</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>34</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>939</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>9</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>35</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>65</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1980</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>36</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>63</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1798</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>37</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>1111</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>N</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>38</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>70</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>4</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>39</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>944</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>18</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>40</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>954</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>41</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>58</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>3</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>42</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>72</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>43</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>74</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>100000</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>44</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>73</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>4</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>45</ns5:id><ns5:poradiStruktury>5</ns5:poradiStruktury><ns5:cisloPole>64</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>118</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>46</ns5:id><ns5:poradiStruktury>6</ns5:poradiStruktury><ns5:cisloPole>131</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>5000.0000000000000000000</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>47</ns5:id><ns5:poradiStruktury>6</ns5:poradiStruktury><ns5:cisloPole>955</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>48</ns5:id><ns5:poradiStruktury>6</ns5:poradiStruktury><ns5:cisloPole>994</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>49</ns5:id><ns5:poradiStruktury>6</ns5:poradiStruktury><ns5:cisloPole>127</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>100000.0000</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>50</ns5:id><ns5:poradiStruktury>6</ns5:poradiStruktury><ns5:cisloPole>186</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>51</ns5:id><ns5:poradiStruktury>6</ns5:poradiStruktury><ns5:cisloPole>129</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0.05</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>52</ns5:id><ns5:poradiStruktury>6</ns5:poradiStruktury><ns5:cisloPole>947</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>S</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>53</ns5:id><ns5:poradiStruktury>6</ns5:poradiStruktury><ns5:cisloPole>284</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>10</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>54</ns5:id><ns5:poradiStruktury>7</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>55</ns5:id><ns5:poradiStruktury>8</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>56</ns5:id><ns5:poradiStruktury>9</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>57</ns5:id><ns5:poradiStruktury>10</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>58</ns5:id><ns5:poradiStruktury>11</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>59</ns5:id><ns5:poradiStruktury>12</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>60</ns5:id><ns5:poradiStruktury>13</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>61</ns5:id><ns5:poradiStruktury>14</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>62</ns5:id><ns5:poradiStruktury>15</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>63</ns5:id><ns5:poradiStruktury>16</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>64</ns5:id><ns5:poradiStruktury>17</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>65</ns5:id><ns5:poradiStruktury>18</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>66</ns5:id><ns5:poradiStruktury>19</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>67</ns5:id><ns5:poradiStruktury>20</ns5:poradiStruktury><ns5:cisloPole>671</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>68</ns5:id><ns5:poradiStruktury>20</ns5:poradiStruktury><ns5:cisloPole>2</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>69</ns5:id><ns5:poradiStruktury>20</ns5:poradiStruktury><ns5:cisloPole>674</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>70</ns5:id><ns5:poradiStruktury>20</ns5:poradiStruktury><ns5:cisloPole>940</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>84</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>71</ns5:id><ns5:poradiStruktury>20</ns5:poradiStruktury><ns5:cisloPole>701</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>72</ns5:id><ns5:poradiStruktury>21</ns5:poradiStruktury><ns5:cisloPole>284</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>11</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>73</ns5:id><ns5:poradiStruktury>21</ns5:poradiStruktury><ns5:cisloPole>955</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>74</ns5:id><ns5:poradiStruktury>21</ns5:poradiStruktury><ns5:cisloPole>994</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>75</ns5:id><ns5:poradiStruktury>21</ns5:poradiStruktury><ns5:cisloPole>186</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>76</ns5:id><ns5:poradiStruktury>21</ns5:poradiStruktury><ns5:cisloPole>947</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>S</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>77</ns5:id><ns5:poradiStruktury>22</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>78</ns5:id><ns5:poradiStruktury>23</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>79</ns5:id><ns5:poradiStruktury>24</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>80</ns5:id><ns5:poradiStruktury>25</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>81</ns5:id><ns5:poradiStruktury>26</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>82</ns5:id><ns5:poradiStruktury>27</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>83</ns5:id><ns5:poradiStruktury>28</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>84</ns5:id><ns5:poradiStruktury>29</ns5:poradiStruktury><ns5:cisloPole>671</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>85</ns5:id><ns5:poradiStruktury>29</ns5:poradiStruktury><ns5:cisloPole>2</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>86</ns5:id><ns5:poradiStruktury>29</ns5:poradiStruktury><ns5:cisloPole>674</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>87</ns5:id><ns5:poradiStruktury>29</ns5:poradiStruktury><ns5:cisloPole>940</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>85</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>88</ns5:id><ns5:poradiStruktury>29</ns5:poradiStruktury><ns5:cisloPole>701</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>89</ns5:id><ns5:poradiStruktury>30</ns5:poradiStruktury><ns5:cisloPole>955</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>90</ns5:id><ns5:poradiStruktury>30</ns5:poradiStruktury><ns5:cisloPole>994</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>91</ns5:id><ns5:poradiStruktury>30</ns5:poradiStruktury><ns5:cisloPole>186</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>92</ns5:id><ns5:poradiStruktury>30</ns5:poradiStruktury><ns5:cisloPole>284</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>3</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>93</ns5:id><ns5:poradiStruktury>30</ns5:poradiStruktury><ns5:cisloPole>127</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>30000</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>94</ns5:id><ns5:poradiStruktury>30</ns5:poradiStruktury><ns5:cisloPole>947</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>S</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>95</ns5:id><ns5:poradiStruktury>30</ns5:poradiStruktury><ns5:cisloPole>130</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>500</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>96</ns5:id><ns5:poradiStruktury>31</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>97</ns5:id><ns5:poradiStruktury>32</ns5:poradiStruktury><ns5:cisloPole>955</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>98</ns5:id><ns5:poradiStruktury>32</ns5:poradiStruktury><ns5:cisloPole>994</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>99</ns5:id><ns5:poradiStruktury>32</ns5:poradiStruktury><ns5:cisloPole>133</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>867</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>100</ns5:id><ns5:poradiStruktury>32</ns5:poradiStruktury><ns5:cisloPole>186</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>101</ns5:id><ns5:poradiStruktury>32</ns5:poradiStruktury><ns5:cisloPole>284</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>3</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>102</ns5:id><ns5:poradiStruktury>32</ns5:poradiStruktury><ns5:cisloPole>947</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>S</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>103</ns5:id><ns5:poradiStruktury>33</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>104</ns5:id><ns5:poradiStruktury>34</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>105</ns5:id><ns5:poradiStruktury>35</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>106</ns5:id><ns5:poradiStruktury>36</ns5:poradiStruktury><ns5:cisloPole>955</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>107</ns5:id><ns5:poradiStruktury>36</ns5:poradiStruktury><ns5:cisloPole>994</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>108</ns5:id><ns5:poradiStruktury>36</ns5:poradiStruktury><ns5:cisloPole>186</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>109</ns5:id><ns5:poradiStruktury>36</ns5:poradiStruktury><ns5:cisloPole>947</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>S</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>110</ns5:id><ns5:poradiStruktury>36</ns5:poradiStruktury><ns5:cisloPole>284</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>7</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>111</ns5:id><ns5:poradiStruktury>37</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>112</ns5:id><ns5:poradiStruktury>38</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>113</ns5:id><ns5:poradiStruktury>39</ns5:poradiStruktury><ns5:cisloPole>127</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>10000</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>114</ns5:id><ns5:poradiStruktury>39</ns5:poradiStruktury><ns5:cisloPole>955</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>115</ns5:id><ns5:poradiStruktury>39</ns5:poradiStruktury><ns5:cisloPole>994</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>116</ns5:id><ns5:poradiStruktury>39</ns5:poradiStruktury><ns5:cisloPole>129</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>0.10</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>117</ns5:id><ns5:poradiStruktury>39</ns5:poradiStruktury><ns5:cisloPole>186</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>118</ns5:id><ns5:poradiStruktury>39</ns5:poradiStruktury><ns5:cisloPole>284</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>4</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>119</ns5:id><ns5:poradiStruktury>39</ns5:poradiStruktury><ns5:cisloPole>947</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>S</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>120</ns5:id><ns5:poradiStruktury>40</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>121</ns5:id><ns5:poradiStruktury>41</ns5:poradiStruktury><ns5:cisloPole>955</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>122</ns5:id><ns5:poradiStruktury>41</ns5:poradiStruktury><ns5:cisloPole>994</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>123</ns5:id><ns5:poradiStruktury>41</ns5:poradiStruktury><ns5:cisloPole>133</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>864</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>124</ns5:id><ns5:poradiStruktury>41</ns5:poradiStruktury><ns5:cisloPole>186</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>125</ns5:id><ns5:poradiStruktury>41</ns5:poradiStruktury><ns5:cisloPole>284</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>2</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>126</ns5:id><ns5:poradiStruktury>41</ns5:poradiStruktury><ns5:cisloPole>947</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>S</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>127</ns5:id><ns5:poradiStruktury>41</ns5:poradiStruktury><ns5:cisloPole>130</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>500</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>128</ns5:id><ns5:poradiStruktury>42</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>129</ns5:id><ns5:poradiStruktury>43</ns5:poradiStruktury><ns5:cisloPole>133</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>863</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>130</ns5:id><ns5:poradiStruktury>43</ns5:poradiStruktury><ns5:cisloPole>955</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>131</ns5:id><ns5:poradiStruktury>43</ns5:poradiStruktury><ns5:cisloPole>994</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>132</ns5:id><ns5:poradiStruktury>43</ns5:poradiStruktury><ns5:cisloPole>284</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>133</ns5:id><ns5:poradiStruktury>43</ns5:poradiStruktury><ns5:cisloPole>186</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>134</ns5:id><ns5:poradiStruktury>43</ns5:poradiStruktury><ns5:cisloPole>947</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>S</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>135</ns5:id><ns5:poradiStruktury>44</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>136</ns5:id><ns5:poradiStruktury>45</ns5:poradiStruktury><ns5:cisloPole>955</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>137</ns5:id><ns5:poradiStruktury>45</ns5:poradiStruktury><ns5:cisloPole>994</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>138</ns5:id><ns5:poradiStruktury>45</ns5:poradiStruktury><ns5:cisloPole>186</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaDatum>2021-08-18T00:00:00.000+02:00</ns5:hodnotaDatum></ns5:pole><ns5:pole><ns5:id>139</ns5:id><ns5:poradiStruktury>45</ns5:poradiStruktury><ns5:cisloPole>284</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>4</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>140</ns5:id><ns5:poradiStruktury>45</ns5:poradiStruktury><ns5:cisloPole>947</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaChar>S</ns5:hodnotaChar></ns5:pole><ns5:pole><ns5:id>141</ns5:id><ns5:poradiStruktury>46</ns5:poradiStruktury><ns5:cisloPole>956</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>142</ns5:id><ns5:poradiStruktury>50</ns5:poradiStruktury><ns5:cisloPole>940</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>79</ns5:hodnotaNumber></ns5:pole><ns5:pole><ns5:id>143</ns5:id><ns5:poradiStruktury>50</ns5:poradiStruktury><ns5:cisloPole>701</ns5:cisloPole><ns5:vstupProBalicky>false</ns5:vstupProBalicky><ns5:hodnotaNumber>1</ns5:hodnotaNumber></ns5:pole></ns5:policka><ns5:fixovaneParametry><ns5:vstupProBalicky>false</ns5:vstupProBalicky></ns5:fixovaneParametry></ns5:transakceVypoctu></ns5:vypocetPojistneho>");

        MyTreeTable myTreeTable = new MyTreeTable( new BalickyTreeTableDataModel(null));
		
		 // create a panel
        JScrollPane p1 = new JScrollPane(txtInput1);
        JScrollPane p = new JScrollPane(myTreeTable);
		
		
		splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, p1, p);
		paneBalicky.add(splitPane);
	
		btnNewButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					parseInput( txtInput1.getText());
					
			        myTreeTable.setModel( new BalickyTreeTableDataModel( structMap.get( 1)));
				} catch (ParserConfigurationException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		});
		
		tabbedPane.addTab( "Balky", paneBalicky);
		
		JPanel paneEarnix = new JPanel();
		paneEarnix.setLayout(new BoxLayout(paneEarnix, BoxLayout.Y_AXIS));
		
		JTextArea earnixInput = new JTextArea();
		earnixInput.setLineWrap(true);
		earnixInput.setWrapStyleWord(true);
		earnixInput.setText("<c:getPricingResultsV6 xmlns:c=\"http://integration.sessions.eo.earnix.com\">\r\n   <systemID>183822</systemID>\r\n   <idType>1</idType>\r\n   <encounter>0</encounter>\r\n   <profileSchema>\r\n      <name>RAMEC</name>\r\n      <attributeNames>\r\n         <string>RS-ZDROJ-KOD-IN</string>\r\n         <string>RS-CONTRACT-ID-IN</string>\r\n         <string>RS-VERZE-ID-IN</string>\r\n         <string>RS_UZIV-UZIVATEL-ID-IN</string>\r\n         <string>RS_UZIV-TYP-KOD-IN</string>\r\n         <string>RS_UZIV-HEC-CIS-IN</string>\r\n         <string>RS_UZIV-OEC-CIS-IN</string>\r\n         <string>RS_UZIV-LOGIN-TXT-IN</string>\r\n         <string>RS_SYSTEM-IN</string>\r\n      </attributeNames>\r\n      <subItems>\r\n         <SchemaV6>\r\n            <name>SMLOUVA</name>\r\n            <attributeNames>\r\n               <string>PS-PRODUKT-KOD-IN</string>\r\n               <string>PS-SMLOUVA-CIS-IN</string>\r\n               <string>PS-DODATEK-CIS-IN</string>\r\n               <string>PS-VERZE-ID-IN</string>\r\n               <string>PS-EARNIX_PRICING_RULE-ID-IN</string>\r\n               <string>PS-SJEDNANO-KOD-IN</string>\r\n               <string>PS-TYP_TRANSAKCE-KOD-IN</string>\r\n               <string>PS-UZIV_PROD_MAXOBCHSLEVA-KOD-IN</string>\r\n               <string>PS-SJEDNANI-DAT-IN</string>\r\n               <string>PS-POCATEK-DAT-IN</string>\r\n               <string>PS-KONEC-DAT-IN</string>\r\n               <string>PS-MIN_VYROCI-DAT-IN</string>\r\n               <string>PS-FREKV_PLACENI-KOD-IN</string>\r\n               <string>PS-PROD_SEGMENT-KOD-IN</string>\r\n               <string>PS-VZNIK-KOD-IN</string>\r\n               <string>PS-POJISTNIK_JE_DRZITEL-KOD-IN</string>\r\n               <string>PS_ZPR-ZPROSTREDKOVATEL-ID-IN</string>\r\n               <string>PS_ZPR-TYP-KOD-IN</string>\r\n               <string>PS_ZPR-HEC-CIS-IN</string>\r\n               <string>PS_ZPR-OEC-CIS-IN</string>\r\n               <string>PS_PJE-CISTE_TYPO-KC-IN</string>\r\n               <string>PS_PJE-SPLATKA_TYPO-KC-IN</string>\r\n               <string>PS_PJE-HRUBE_TYPO-KC-IN</string>\r\n               <string>PS_PJE-EXTERNI_CISLO_SMLOUVY-IN</string>\r\n               <string>PS_PJE-EXTERNI_CISLO_KALK-IN</string>\r\n               <string>PS-COBRANDING-KOD-IN</string>\r\n               <string>PS-SYS_DATE-DAT-IN</string>\r\n               <string>PS-NABIDKA-CIS-IN</string>\r\n            </attributeNames>\r\n            <subItems>\r\n               <SchemaV6>\r\n                  <name>PS_OSOBA</name>\r\n                  <attributeNames>\r\n                     <string>PS_OSO-OSOBA-ID-IN</string>\r\n                     <string>PS_OSO-ROLE-KOD-IN</string>\r\n                     <string>PS_OSO-SHODNY-ID-IN</string>\r\n                     <string>PS_OSO-TYP-KOD-IN</string>\r\n                     <string>PS_OSO-RC-ID-IN</string>\r\n                     <string>PS_OSO-NAROZENI-DAT-IN</string>\r\n                     <string>PS_OSO-JMENO-TXT-IN</string>\r\n                     <string>PS_OSO-PRIJMENI-TXT-IN</string>\r\n                     <string>PS_OSO-IC-ID-IN</string>\r\n                     <string>PS_OSO-PSC-KOD-IN</string>\r\n                     <string>PS_OSO-OBEC-ID-IN</string>\r\n                     <string>PS_OSO-OBYVATEL_OBCE-CIS-IN</string>\r\n                     <string>PS_OSO-VELIKOST_OBCE-KOD-IN</string>\r\n                     <string>PS_OSO-KATEGORIE_KLIENTA-KOD-IN</string>\r\n                     <string>PS_OSO-BA_SCORE-TXT-IN</string>\r\n                     <string>PS_OSO-BM_ROZHODNA_DOBA_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_TRVANI_POJISTENI_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_POCET_SKOD_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_POCET_MESICU_10_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_POCET_SKOD_10_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_POSLEDNI_SKODA_CKPN-DAT-IN</string>\r\n                     <string>PS_OSO-BM_ZANIKU_NEPLACENIM_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_POCET_VSECH_MESICU_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_POCET_SKOD_ZAHR_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_REZERVA_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_PLNENI_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_REGRES_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_CKPN_DOTAZENO-KOD-IN</string>\r\n                     <string>PS_OSO-BA_SOUHLAS-KOD-IN</string>\r\n                     <string>PS_OSO-BA_DOTAZENO-KOD-IN</string>\r\n                     <string>PS_OSO-BM_CKPN_NOUZOVY_REZIM-KOD-IN</string>\r\n                     <string>PS_OSO-BM_ZANIKU_NEPLACENIM_10_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-BM_POSLEDNI_ZANIK_NEPLACENIM_CKPN-DAT-IN</string>\r\n                     <string>PS_OSO-BM_PRUMER_VOZIDEL_10_CKPN-CIS-IN</string>\r\n                     <string>PS_OSO-POJ_SCORE-TXT-IN</string>\r\n                     <string>PS_OSO-EAR_SCORE-TXT-IN</string>\r\n                     <string>PS_OSO-NACE_PREV-KOD-IN</string>\r\n                  </attributeNames>\r\n                  <subItems/>\r\n               </SchemaV6>\r\n               <SchemaV6>\r\n                  <name>PS_SLEVA</name>\r\n                  <attributeNames>\r\n                     <string>PS_SLE-SLEVA-ID-IN</string>\r\n                     <string>PS_SLE-TYP-KOD-IN</string>\r\n                     <string>PS_SLE-UPLATENENA-KOD-IN</string>\r\n                     <string>PS_SLE-KUPON-CIS-IN</string>\r\n                     <string>PS_SLE_PJE-VYSE-KOEF-IN</string>\r\n                  </attributeNames>\r\n                  <subItems/>\r\n               </SchemaV6>\r\n               <SchemaV6>\r\n                  <name>PREDMET</name>\r\n                  <attributeNames>\r\n                     <string>PRE-PREDMET-ID-IN</string>\r\n                     <string>PRE-TYP-KOD-IN</string>\r\n                     <string>PRE-SJEDNANO-KOD-IN</string>\r\n                     <string>PRE-UZITI-KOD-IN</string>\r\n                     <string>PRE-KATEGORIE-KOD-IN</string>\r\n                     <string>PRE-ZNACKA-KOD-IN</string>\r\n                     <string>PRE-PROVEDENI-CIS-IN</string>\r\n                     <string>PRE-OBJEM-CIS-IN</string>\r\n                     <string>PRE-VYKON-CIS-IN</string>\r\n                     <string>PRE-HMOTNOST-CIS-IN</string>\r\n                     <string>PRE-ROK_VYROBY-DAT-IN</string>\r\n                     <string>PRE-POCET_MIST-CIS-IN</string>\r\n                     <string>PRE-POJ_CASTKA-KOD-IN</string>\r\n                     <string>PRE-CENA_VOZIDLA-KC-IN</string>\r\n                     <string>PRE-CENA_BEZ_VYBAVY-KC-IN</string>\r\n                     <string>PRE-ZABEZPECENI-KOD-IN</string>\r\n                     <string>PRE-SKUPINA_ZNACEK-KOD-IN</string>\r\n                     <string>PRE-SPZ_TXT-IN</string>\r\n                     <string>PRE-VIN_TXT-IN</string>\r\n                  </attributeNames>\r\n                  <subItems>\r\n                     <SchemaV6>\r\n                        <name>POJISTENI</name>\r\n                        <attributeNames>\r\n                           <string>PJI-POJISTENI-ID-IN</string>\r\n                           <string>PJI-TYP-KOD-IN</string>\r\n                           <string>PJI-SJEDNANO-KOD-IN</string>\r\n                           <string>PJI-TYP_TRANSAKCE-KOD-IN</string>\r\n                           <string>PJI-VARIANTA-KOD-IN</string>\r\n                           <string>PJI-TYPO_VARIANTA-KOD-IN</string>\r\n                           <string>PJI-KATEGORIE_KLIENTA-KOD-IN</string>\r\n                           <string>PJI-POCATEK-DAT-IN</string>\r\n                           <string>PJI-KONEC-DAT-IN</string>\r\n                           <string>PJI-POJ_CASTKA-KC-IN</string>\r\n                           <string>PJI-SPOLUC-KOEF-IN</string>\r\n                           <string>PJI-SPOLUC_MIN-KC-IN</string>\r\n                           <string>PJI-SPOLUC_CAST-KC-IN</string>\r\n                           <string>PJI-KUMUL_RETENCE-KOEF-IN</string>\r\n                           <string>PJI-PRECENENI-KOEF-IN</string>\r\n                           <string>PJI_PJE-HRUBE_TYPO-KC-IN</string>\r\n                        </attributeNames>\r\n                        <subItems>\r\n                           <SchemaV6>\r\n                              <name>PJI_SLEVA</name>\r\n                              <attributeNames>\r\n                                 <string>PJI_SLE-SLEVA-ID-IN</string>\r\n                                 <string>PJI_SLE-TYP-KOD-IN</string>\r\n                                 <string>PJI_SLE-UPLATENENA-KOD-IN</string>\r\n                                 <string>PJI_SLE-BM_ZISKANE-CIS-IN</string>\r\n                                 <string>PJI_SLE-BM_PREVADENE-CIS-IN</string>\r\n                                 <string>PJI_SLE-BM_PREVADENE_CKP-CIS-IN</string>\r\n                                 <string>PJI_SLE_PJE-VYSE-KOEF-IN</string>\r\n                                 <string>PJI_SLE-TOLERANCE-CIS-IN</string>\r\n                                 <string>PJI_SLE-BM_POCET_MESICU_MANUAL-CIS-IN</string>\r\n                                 <string>PJI_SLE-BM_POCET_SKOD_MANUAL-CIS-IN</string>\r\n                              </attributeNames>\r\n                              <subItems/>\r\n                           </SchemaV6>\r\n                           <SchemaV6>\r\n                              <name>RIZIKO</name>\r\n                              <attributeNames>\r\n                                 <string>RIZ-RIZIKO-ID-IN</string>\r\n                                 <string>RIZ-TYP-KOD-IN</string>\r\n                                 <string>RIZ-SJEDNANO-KOD-IN</string>\r\n                                 <string>RIZ-VARIANTA-KOD-IN</string>\r\n                                 <string>RIZ-POJ_CASTKA-KC-IN</string>\r\n                              </attributeNames>\r\n                              <subItems/>\r\n                           </SchemaV6>\r\n                        </subItems>\r\n                     </SchemaV6>\r\n                  </subItems>\r\n               </SchemaV6>\r\n               <SchemaV6>\r\n                  <name>FIX_PARAMS</name>\r\n                  <attributeNames>\r\n                     <string>PS_FIX-POV-DRZITEL_ROK_NAROZENI-DAT-IN</string>\r\n                     <string>PS_FIX-HAV-PRE-ROK_VYROBY-DAT-IN</string>\r\n                     <string>PS_FIX-ODC-PRE-ROK_VYROBY-DAT-IN</string>\r\n                     <string>PS_FIX-POV-DRZITEL_OBYVATEL_OBCE-CIS-IN</string>\r\n                     <string>PS_FIX-HAV-DRZITEL_OBYVATEL_OBCE-CIS-IN</string>\r\n                     <string>PS_FIX-ODC-DRZITEL_OBYVATEL_OBCE-CIS-IN</string>\r\n                     <string>PS_FIX-POV-PRE-ROK_VYROBY-DAT-IN</string>\r\n                     <string>PS_FIX-POV-DRZITEL_PSC-CIS-IN</string>\r\n                     <string>PS_FIX-HAV-DRZITEL_PSC-CIS-IN</string>\r\n                     <string>PS_FIX-ODC-DRZITEL_PSC-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_PREVADENE_CKP-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_PREVADENE-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_ROZHODNA_DOBA_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_TRVANI_POJISTENI_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_POCET_SKOD_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_POCET_MESICU_10_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_POCET_SKOD_10_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_POSLEDNI_SKODA_CKPN-DAT-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_ZANIKU_NEPLACENIM_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_RIZIKOVOST_CKPN-KOEF-IN</string>\r\n                     <string>PS_FIX-POV-KATEGORIE_KLIENTA-KOD-IN</string>\r\n                     <string>PS_FIX-POV-PRE-KATEGORIE-KOD-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-RC-ID-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-IC-ID-IN</string>\r\n                     <string>PS_FIX-POV-BM_CKPN_DOTAZENO-KOD-IN</string>\r\n                     <string>PS_FIX-POV-DRUHY_ZDROJ-IC-ID-IN</string>\r\n                     <string>PS_FIX-POV-DRUHY_ZDROJ-RC-ID-IN</string>\r\n                     <string>PS_FIX-POV-DRUHY_ZDROJ-JMENO-TXT-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-JMENO-TXT-IN</string>\r\n                     <string>PS_FIX-FIXACE-DAT-IN</string>\r\n                     <string>PS_FIX-POV-BM_CKPN_NOUZOVY_REZIM-KOD-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_TOLERANCE-CIS-IN</string>\r\n                     <string>PS_FIX-OSO-BA_DOTAZENO-KOD-IN</string>\r\n                     <string>PS_FIX-OSO-BA_SOUHLAS-KOD-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_POCET_VSECH_MESICU_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_POCET_SKOD_ZAHR_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_REZERVA_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_PLNENI_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_REGRES_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-PRIJMENI-TXT-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_ZANIKU_NEPLACENIM_10_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_POSLEDNI_ZANIK_NEPLACENIM_CKPN-DAT-IN</string>\r\n                     <string>PS_FIX-POV-POJISTNIK-BM_PRUMER_VOZIDEL_10_CKPN-CIS-IN</string>\r\n                     <string>PS_FIX-POJISTNIK-POJ_SCORE-TXT-IN</string>\r\n                     <string>PS_FIX-POJISTNIK-BA_SCORE-TXT-IN</string>\r\n                     <string>PS_FIX-POJISTNIK-EAR_SCORE-TXT-IN</string>\r\n                     <string>PS_FIX-POJISTNIK-NACE_PREV-KOD-IN</string>\r\n                  </attributeNames>\r\n                  <subItems/>\r\n               </SchemaV6>\r\n            </subItems>\r\n         </SchemaV6>\r\n      </subItems>\r\n   </profileSchema>\r\n   <profiles>\r\n      <ProfileValues>\r\n        <values>\r\n            <string>12</string>\r\n            <string>1|1|1|6154843519||1|1|0</string>\r\n            <string/>\r\n            <string/>\r\n            <string/>\r\n            <!--RS_UZIV-HEC-CIS-->\r\n            <string>2110486</string>\r\n            <!--RS_UZIV-OEC-CIS-->\r\n            <string/>\r\n            <!--RS_UZIV-LOGIN-TXT-->\r\n            <string>cermakp</string>\r\n            <string>BAL|NaN</string>\r\n         </values>\r\n         <subItems>\r\n            <SubItem>\r\n               <profiles>\r\n                  <ProfileValues>\r\n                     <values>\r\n                        <string>114</string>\r\n                        <string>6154843519.0000000000000000000</string>\r\n                        <string/>\r\n                        <string/>\r\n                        <string>183822</string>\r\n                        <string>1</string>\r\n                        <string>S</string>\r\n                        <string/>\r\n                        <string>17/08/2021</string>\r\n                        <string>18/08/2021</string>\r\n                        <string/>\r\n                        <string/>\r\n                        <string>1</string>\r\n                        <string/>\r\n                        <string>1</string>\r\n                        <string/>\r\n                        <string/>\r\n                        <string/>\r\n                        <string>8100588</string>\r\n                        <string/>\r\n                        <string/>\r\n                        <string/>\r\n                        <string/>\r\n                        <string/>\r\n                        <string/>\r\n                        <string/>\r\n                        <string>18/08/2021</string>\r\n                        <string/>\r\n                     </values>\r\n                     <subItems>\r\n                        <SubItem>\r\n                           <profiles>\r\n                              <ProfileValues>\r\n                                 <values>\r\n                                    <string>4|10|1|2|2|2||false|tmpAnonymCalc|tmpNouzovyRezim</string>\r\n                                    <string>2</string>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string>8504254022</string>\r\n                                    <string/>\r\n                                    <string>Ji\u0159\u00ED</string>\r\n                                    <string>Nepov\u00EDm</string>\r\n                                    <string/>\r\n                                    <string>53002</string>\r\n                                    <string>9598</string>\r\n                                    <string>1799</string>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                 </values>\r\n                              </ProfileValues>\r\n                              <ProfileValues>\r\n                                 <values>\r\n                                    <string>4|11|1|3|3|7||false|tmpAnonymCalc|tmpNouzovyRezim</string>\r\n                                    <string>7</string>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string>1799</string>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                 </values>\r\n                              </ProfileValues>\r\n                              <ProfileValues>\r\n                                 <values>\r\n                                    <string>4|12|1|4|4|8||true|tmpAnonymCalc|tmpNouzovyRezim</string>\r\n                                    <string>8</string>\r\n                                    <string>10</string>\r\n                                    <string>0</string>\r\n                                    <string>8504254022</string>\r\n                                    <string>01/01/1985</string>\r\n                                    <string>Ji\u0159\u00ED</string>\r\n                                    <string>Nepov\u00EDm</string>\r\n                                    <string/>\r\n                                    <string>53002</string>\r\n                                    <string>9598</string>\r\n                                    <string>1799</string>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string>1</string>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                 </values>\r\n                              </ProfileValues>\r\n                           </profiles>\r\n                        </SubItem>\r\n                        <SubItem>\r\n                           <profiles>\r\n                              <ProfileValues>\r\n                                 <values>\r\n                                    <string>12|5|1|50|50</string>\r\n                                    <string>79</string>\r\n                                    <string>1</string>\r\n                                    <string/>\r\n                                    <string/>\r\n                                 </values>\r\n                              </ProfileValues>\r\n                           </profiles>\r\n                        </SubItem>\r\n                        <SubItem>\r\n                           <profiles>\r\n                              <ProfileValues>\r\n                                 <values>\r\n                                    <string>8|4|1|5|5</string>\r\n                                    <string>18</string>\r\n                                    <string>1</string>\r\n                                    <string>0</string>\r\n                                    <string>3</string>\r\n                                    <string>11</string>\r\n                                    <string>970</string>\r\n                                    <string>1798</string>\r\n                                    <string>118</string>\r\n                                    <string>1980</string>\r\n                                    <string>01/01/2011</string>\r\n                                    <string>4</string>\r\n                                    <string>4</string>\r\n                                    <string>100000</string>\r\n                                    <string>0</string>\r\n                                    <string/>\r\n                                    <string>9</string>\r\n                                    <string/>\r\n                                    <string/>\r\n                                 </values>\r\n                                 <subItems>\r\n                                    <SubItem>\r\n                                       <profiles>\r\n                                          <ProfileValues>\r\n                                             <values>\r\n                                                <string>11|80|4|5|6|6</string>\r\n                                                <string>80</string>\r\n                                                <string>1</string>\r\n                                                <string>S</string>\r\n                                                <string>10</string>\r\n                                               <string/>\r\n                                                <string/>\r\n                                                <string>18/08/2021</string>\r\n                                                <string/>\r\n                                                <string>100000.0000</string>\r\n                                                <string>0.05</string>\r\n                                                <string>5000.0000000000000000000</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>1</string>\r\n                                                <string/>\r\n                                             </values>\r\n                                             <subItems>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>12|3|80|4|6|20|20|84</string>\r\n                                                            <string>84</string>\r\n                                                            <string>1</string>\r\n                                                            <string>0</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                            <string>0</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                         <subItems/>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|1|80|4|6|7|7</string>\r\n                                                            <string>1</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|3|80|4|6|8|8</string>\r\n                                                            <string>3</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|4|80|4|6|9|9</string>\r\n                                                            <string>4</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|5|80|4|6|10|10</string>\r\n                                                            <string>5</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|7|80|4|6|11|11</string>\r\n                                                            <string>7</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|8|80|4|6|12|12</string>\r\n                                                            <string>8</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|9|80|4|6|13|13</string>\r\n                                                            <string>9</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|10|80|4|6|14|14</string>\r\n                                                            <string>10</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|11|80|4|6|15|15</string>\r\n                                                            <string>11</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|19|80|4|6|16|16</string>\r\n                                                            <string>19</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|45|80|4|6|17|17</string>\r\n                                                            <string>45</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|46|80|4|6|18|18</string>\r\n                                                            <string>46</string>\r\n                                                            <string>1</string>\r\n                                                           <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|271|80|4|6|19|19</string>\r\n                                                            <string>271</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                             </subItems>\r\n                                          </ProfileValues>\r\n                                          <ProfileValues>\r\n                                             <values>\r\n                                                <string>11|81|4|5|21|21</string>\r\n                                                <string>81</string>\r\n                                                <string>1</string>\r\n                                                <string>S</string>\r\n                                                <string>11</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>18/08/2021</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>1</string>\r\n                                                <string/>\r\n                                             </values>\r\n                                             <subItems>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>12|4|81|4|21|29|29|85</string>\r\n                                                            <string>85</string>\r\n                                                            <string>1</string>\r\n                                                            <string>0</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                            <string>0</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                         <subItems/>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|13|81|4|21|22|22</string>\r\n                                                            <string>13</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|21|81|4|21|23|23</string>\r\n                                                            <string>21</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|60|81|4|21|24|24</string>\r\n                                                            <string>60</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|61|81|4|21|25|25</string>\r\n                                                            <string>61</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|62|81|4|21|26|26</string>\r\n                                                            <string>62</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|63|81|4|21|27|27</string>\r\n                                                            <string>63</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|64|81|4|21|28|28</string>\r\n                                                            <string>64</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                             </subItems>\r\n                                          </ProfileValues>\r\n                                          <ProfileValues>\r\n                                             <values>\r\n                                                <string>11|84|4|5|30|30</string>\r\n                                                <string>84</string>\r\n                                                <string>1</string>\r\n                                                <string>S</string>\r\n                                                <string>3</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>18/08/2021</string>\r\n                                                <string/>\r\n                                                <string>30000</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>500</string>\r\n                                                <string/>\r\n                                                <string>1</string>\r\n                                                <string/>\r\n                                             </values>\r\n                                             <subItems>\r\n                                                <SubItem>\r\n                                                   <profiles/>\r\n                                                </SubItem>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|16|84|4|30|31|31</string>\r\n                                                            <string>16</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                             </subItems>\r\n                                          </ProfileValues>\r\n                                          <ProfileValues>\r\n                                             <values>\r\n                                                <string>11|83|4|5|32|32</string>\r\n                                                <string>83</string>\r\n                                                <string>1</string>\r\n                                                <string>S</string>\r\n                                                <string>3</string>\r\n                                                <string>867</string>\r\n                                                <string/>\r\n                                                <string>18/08/2021</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>1</string>\r\n                                                <string/>\r\n                                             </values>\r\n                                             <subItems>\r\n                                                <SubItem>\r\n                                                   <profiles/>\r\n                                                </SubItem>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|105|83|4|32|33|33</string>\r\n                                                            <string>105</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|106|83|4|32|34|34</string>\r\n                                                            <string>106</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|107|83|4|32|35|35</string>\r\n                                                            <string>107</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                             </subItems>\r\n                                          </ProfileValues>\r\n                                          <ProfileValues>\r\n                                             <values>\r\n                                                <string>11|137|4|5|36|36</string>\r\n                                                <string>137</string>\r\n                                                <string>1</string>\r\n                                                <string>S</string>\r\n                                                <string>7</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>18/08/2021</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>1</string>\r\n                                                <string/>\r\n                                             </values>\r\n                                             <subItems>\r\n                                                <SubItem>\r\n                                                   <profiles/>\r\n                                                </SubItem>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|276|137|4|36|37|37</string>\r\n                                                            <string>276</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|277|137|4|36|38|38</string>\r\n                                                            <string>277</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                             </subItems>\r\n                                          </ProfileValues>\r\n                                          <ProfileValues>\r\n                                             <values>\r\n                                                <string>11|85|4|5|39|39</string>\r\n                                                <string>85</string>\r\n                                                <string>1</string>\r\n                                                <string>S</string>\r\n                                                <string>4</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>18/08/2021</string>\r\n                                                <string/>\r\n                                                <string>10000</string>\r\n                                                <string>0.10</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>1</string>\r\n                                                <string/>\r\n                                             </values>\r\n                                             <subItems>\r\n                                                <SubItem>\r\n                                                   <profiles/>\r\n                                                </SubItem>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|14|85|4|39|40|40</string>\r\n                                                            <string>14</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                             </subItems>\r\n                                          </ProfileValues>\r\n                                          <ProfileValues>\r\n                                             <values>\r\n                                                <string>11|86|4|5|41|41</string>\r\n                                                <string>86</string>\r\n                                                <string>1</string>\r\n                                                <string>S</string>\r\n                                                <string>2</string>\r\n                                                <string>864</string>\r\n                                                <string/>\r\n                                                <string>18/08/2021</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>500</string>\r\n                                                <string/>\r\n                                                <string>1</string>\r\n                                                <string/>\r\n                                             </values>\r\n                                             <subItems>\r\n                                                <SubItem>\r\n                                                   <profiles/>\r\n                                                </SubItem>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|17|86|4|41|42|42</string>\r\n                                                            <string>17</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                             </subItems>\r\n                                          </ProfileValues>\r\n                                          <ProfileValues>\r\n                                             <values>\r\n                                                <string>11|170|4|5|43|43</string>\r\n                                                <string>170</string>\r\n                                                <string>1</string>\r\n                                                <string>S</string>\r\n                                                <string>1</string>\r\n                                                <string>863</string>\r\n                                                <string/>\r\n                                                <string>18/08/2021</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>1</string>\r\n                                                <string/>\r\n                                             </values>\r\n                                             <subItems>\r\n                                                <SubItem>\r\n                                                   <profiles/>\r\n                                                </SubItem>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|325|170|4|43|44|44</string>\r\n                                                            <string>325</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                             </subItems>\r\n                                          </ProfileValues>\r\n                                          <ProfileValues>\r\n                                             <values>\r\n                                                <string>11|87|4|5|45|45</string>\r\n                                                <string>87</string>\r\n                                                <string>1</string>\r\n                                                <string>S</string>\r\n                                                <string>4</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>18/08/2021</string>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string/>\r\n                                                <string>1</string>\r\n                                                <string/>\r\n                                             </values>\r\n                                             <subItems>\r\n                                                <SubItem>\r\n                                                   <profiles/>\r\n                                                </SubItem>\r\n                                                <SubItem>\r\n                                                   <profiles>\r\n                                                      <ProfileValues>\r\n                                                         <values>\r\n                                                            <string>13|18|87|4|45|46|46</string>\r\n                                                            <string>18</string>\r\n                                                            <string>1</string>\r\n                                                            <string/>\r\n                                                            <string/>\r\n                                                         </values>\r\n                                                      </ProfileValues>\r\n                                                   </profiles>\r\n                                                </SubItem>\r\n                                             </subItems>\r\n                                          </ProfileValues>\r\n                                       </profiles>\r\n                                    </SubItem>\r\n                                 </subItems>\r\n                              </ProfileValues>\r\n                           </profiles>\r\n                        </SubItem>\r\n                        <SubItem>\r\n                           <profiles>\r\n                              <ProfileValues>\r\n                                 <values>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                    <string/>\r\n                                 </values>\r\n                              </ProfileValues>\r\n                           </profiles>\r\n                        </SubItem>\r\n                     </subItems>\r\n                  </ProfileValues>\r\n               </profiles>\r\n            </SubItem>\r\n         </subItems>\r\n      </ProfileValues>\r\n   </profiles>\r\n</c:getPricingResultsV6>");
		
		 // create a panel

		JPanel panelEarnixLeft = new JPanel();
		panelEarnixLeft.setLayout(new BoxLayout(panelEarnixLeft, BoxLayout.Y_AXIS));

		JButton parseEarnixButton = new JButton("PARSE");
		panelEarnixLeft.add( parseEarnixButton);
		
        JScrollPane panelEarnixInput = new JScrollPane(earnixInput);
        panelEarnixLeft.add( panelEarnixInput);
        
		JPanel panelEarnixRight = new JPanel();
		panelEarnixRight.setLayout(new BoxLayout(panelEarnixRight, BoxLayout.Y_AXIS));

		JPanel panelEarnixFilter = new JPanel();
		panelEarnixFilter.setLayout(new BoxLayout(panelEarnixFilter, BoxLayout.X_AXIS));
		panelEarnixFilter.setAlignmentX( Component.CENTER_ALIGNMENT);

		JButton findPrevButton = new JButton("<<");
		findPrevButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				filterPrev();
			}
		});
		
		filterText = new JTextField();
		filterText.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			}
		});
		
		filterNazevCheck = new JRadioButton("n\u00E1zev");
		filterNazevCheck.setSelected(true);
		panelEarnixFilter.add(filterNazevCheck);
		
		
		filterHodnotaCheck = new JRadioButton("hodnota");
		ButtonGroup bg = new ButtonGroup();
		bg.add( filterNazevCheck);
		bg.add( filterHodnotaCheck);
		
		panelEarnixFilter.add(filterHodnotaCheck);
		panelEarnixFilter.add(filterText);
		filterText.setColumns(1);
		panelEarnixFilter.add( findPrevButton);
		
		filterNazevCheck.addActionListener( new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				filterPerformNewSearch();
			}});

		filterHodnotaCheck.addActionListener( new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent e) {
				filterPerformNewSearch();
			}});

		JButton findNextButton = new JButton(">>");
		findNextButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				filterNext();
			}
		});
		parseEarnixButton.setHorizontalAlignment(SwingConstants.LEADING);
		panelEarnixFilter.add( findNextButton);
		
		panelEarnixRight.add( panelEarnixFilter);
		
		filterCountIndicator = new JLabel("");
		panelEarnixFilter.add(filterCountIndicator);
		filterCountIndicator.setText( "-/-");						
		
        JScrollPane panelEarnixAttributeTableScroll = new JScrollPane();
        JScrollPane panelEarnixTreeTableScroll = new JScrollPane();
		panelEarnixTreeTableScroll.setAlignmentX( Component.CENTER_ALIGNMENT);

		JSplitPane splitPaneEarnixRight = new JSplitPane(JSplitPane.VERTICAL_SPLIT, panelEarnixAttributeTableScroll, panelEarnixTreeTableScroll);
		panelEarnixRight.add( splitPaneEarnixRight);
		splitPaneEarnixRight.setAlignmentX( Component.CENTER_ALIGNMENT);
		
        earnixTreeTable = new MyTreeTable( new EarnixTreeTableDataModel(null));
		panelEarnixTreeTableScroll.setViewportView(earnixTreeTable);
		earnixTreeTable.setColumnSelectionAllowed(false);
		earnixTreeTable.setRowSelectionAllowed(true);

		filterText.addKeyListener( new KeyListener() {
			@Override
			public void keyTyped(KeyEvent e) {
			}

			@Override
			public void keyPressed(KeyEvent e) {
			}

			@Override
			public void keyReleased(KeyEvent e) {
				filterPerformNewSearch();
			}
		});

		
		JSplitPane splitPaneEarnix = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, panelEarnixLeft, panelEarnixRight);
		paneEarnix.add( splitPaneEarnix);

		Dimension minimumSize = new Dimension(200, 200);
		panelEarnixLeft.setMinimumSize(minimumSize);
		panelEarnixRight.setMinimumSize(minimumSize);
		splitPaneEarnix.setResizeWeight(1.0);

		table = new JTable();
		table.setModel(new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"Path", "Id", "Value"
			}
		) {
			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;
			boolean[] columnEditables = new boolean[] {
				false, true, true
			};
			public boolean isCellEditable(int row, int column) {
				return columnEditables[column];
			}
		});

		panelEarnixAttributeTableScroll.setViewportView(table);
		
		parseEarnixButton.setPreferredSize( new Dimension(100, 100));
		parseEarnixButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				parseEarnixInput( earnixInput.getText());
				table.setModel( new EarnixStructTableModel( rootEarnixAttributeStruct));
		        earnixTreeTable.setModel( new EarnixTreeTableDataModel( rootEarnixValueStruct));
			}
		});

		tabbedPane.addTab( "Earnix", paneEarnix);
		
		tabbedPane.setSelectedComponent(paneEarnix);
	}
	
	protected void filterPerformNewSearch() {
		filterRowsFound.clear();
		
		for( int index = 0; index < earnixTreeTable.getRowCount(); index++)
		{
			String textFound = earnixTreeTable.getModel().getValueAt( index, filterNazevCheck.isSelected()?0:1).toString();
			if( textFound.contains( filterText.getText())) {
				filterRowsFound.add( index);
			}
		}
		
		filterUpdate();
		filterRowsCurrentIndex = -1;
		if( filterRowsFound.size() != 0)
			filterNext();
	}

	private void parseInput(String text) throws ParserConfigurationException {
		// Instantiate the Factory
	    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
	    dbf.setNamespaceAware( true);
	    
        // parse XML file
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc;
        
        try {
        	doc = db.parse( new ByteArrayInputStream(text.getBytes( "UTF-8")));
	        doc.getDocumentElement().normalize();
	        System.out.println("START");
	        
			structMap = new HashMap<Integer, BalickyDataNode>();

	          NodeList list = doc.getElementsByTagName("ns5:struktura");
	          for (int temp = 0; temp < list.getLength(); temp++) {
	        	  parseStruktury( list.item(temp));
	          }
	          list = doc.getElementsByTagName("ns5:pole");
	          for (int temp = 0; temp < list.getLength(); temp++) {
	        	  parsePole( list.item(temp));
	          }

		} catch (SAXException | IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private void parseEarnixInput(String text) {
		// Instantiate the Factory
	    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
	    dbf.setNamespaceAware( true);
	    
        // parse XML file
        DocumentBuilder db;
		try {
			db = dbf.newDocumentBuilder();
			
        	Document doc = db.parse( new ByteArrayInputStream(text.getBytes( "UTF-8")));
	        doc.getDocumentElement().normalize();
	        System.out.println("START EARNIX");
	        
			NodeList list = doc.getElementsByTagName( "profileSchema");
			if( list.getLength() == 0)
			{
				System.out.println( "NO profileSchema found !!!");
				return;
			}
	        parseEarnixInputAttributesRecursive( list.item(0), null);
	        parseEarnixInputValuesRecursive( doc, rootEarnixAttributeStruct, null);
		} catch (ParserConfigurationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (SAXException | IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private void parseEarnixInputValuesRecursive(Node node, EarnixStruct currentAttributeStruct, EarnixStruct parentValueStruct) {
		int values;
		NodeList profilesList;

		tabulator += ".\t";
//		System.out.println( tabulator + currentStruct.getName());
		
		if( node instanceof Element)
			profilesList = ((Element)node).getElementsByTagName( "profiles");
		else
			profilesList = ((Document)node).getElementsByTagName( "profiles");
			
		for( int profilesListIndex = 0; profilesListIndex < 1/*profilesList.getLength()*/; profilesListIndex++) {

			NodeList profileValuesList = ((Element)profilesList.item(profilesListIndex)).getElementsByTagName( "ProfileValues");
			for( int profileValuesListIndex = 0; profileValuesListIndex < profileValuesList.getLength(); profileValuesListIndex++) {
	        	if( isNotDirectChild( profilesList.item(profilesListIndex), profileValuesList.item(profileValuesListIndex)))
	        		continue;

	        	// zalozit novou vystupni strukturu
//	        	System.out.println( "--- NOVA STRUKTURA ---");
    			EarnixStruct newEarnixValueStruct = currentAttributeStruct.createNewInstance( parentValueStruct);

    			// if parent is null it is root item else it have to be added to parents list of children
	        	if( parentValueStruct == null) {
	    			rootEarnixValueStruct = newEarnixValueStruct;
	    		}else {
	    			parentValueStruct.addSubitem( newEarnixValueStruct);
	    		}
	        	
				NodeList valuesList = ((Element)profileValuesList.item(profileValuesListIndex)).getElementsByTagName( "values");
				for( int valuesListIndex = 0; valuesListIndex < valuesList.getLength(); valuesListIndex++) {
		        	if( isNotDirectChild( profileValuesList.item(profileValuesListIndex), valuesList.item(valuesListIndex)))
		        		continue;

		    		values = 0;
					NodeList stringList = ((Element)valuesList.item(valuesListIndex)).getElementsByTagName( "string");
					for( int stringListIndex = 0; stringListIndex < stringList.getLength(); stringListIndex++) {
						// pridat hodnoty do struktury
						newEarnixValueStruct.setValue( values, ((Element)stringList.item(stringListIndex)).getTextContent());
						values++;
						System.out.println( currentAttributeStruct.toString() + " " + currentAttributeStruct.getAttributeList().get(stringListIndex).getKey() + " " + ((Element)stringList.item(stringListIndex)).getTextContent());
						// add string as value ((Element)stringList.item(stringListIndex))
					}
//					System.out.println( tabulator + ".\t" + stringList.getLength() + " Values");
				}

				NodeList subItemsList = ((Element)profileValuesList.item(profileValuesListIndex)).getElementsByTagName( "subItems");
				for( int subItemsListIndex = 0; subItemsListIndex < subItemsList.getLength(); subItemsListIndex++) {
		        	if( isNotDirectChild( profileValuesList.item(profileValuesListIndex), subItemsList.item(subItemsListIndex)))
		        		continue;
					
					NodeList subItemList = ((Element)subItemsList.item(subItemsListIndex)).getElementsByTagName( "SubItem");
					int index = 0;
					for( int subItemListIndex = 0; subItemListIndex < subItemList.getLength(); subItemListIndex++) {
			        	if( isNotDirectChild( subItemsList.item(subItemsListIndex), subItemList.item( subItemListIndex)))
			        		continue;

						// vstup do podrazeneho prvku
						parseEarnixInputValuesRecursive( subItemList.item( subItemListIndex), currentAttributeStruct.getSubItems().get( index++), newEarnixValueStruct);
					}
				}
			}
			// vstup do dalsi sibling struktury, pokud existuje
		}
		System.out.println( tabulator + currentAttributeStruct.getName() + "EXITING");
		tabulator = tabulator.substring( 0, tabulator.length() - 2);
	}

	boolean isNotDirectChild( Node parent, Node child) {
		return !child.getParentNode().isSameNode(parent);
	}
	
	private void parseEarnixInputAttributesRecursive(Node node, EarnixStruct parentStruct) {
		NodeList list = ((Element)node).getElementsByTagName( "name");
		
		if( list.getLength() == 0)
		{
			System.out.println( "EMPTY ITEM FOUND");
			return;
		}
		
		// I have name
		
		// create new struct
		EarnixStruct newEarnixStruct = new EarnixStruct( ((Element)list.item(0)).getTextContent(), parentStruct);
		System.out.println( "Add new STRUCT: " + newEarnixStruct);
		
		// assign to parent or assign to root if no parent
		if( parentStruct == null)
			rootEarnixAttributeStruct = newEarnixStruct;
		else
			parentStruct.addSubitem( newEarnixStruct);

		// parse attributes
		NodeList attributeList = ((Element)node).getElementsByTagName( "attributeNames");
        for (int attributeListIndex = 0; attributeListIndex < attributeList.getLength(); attributeListIndex++) {
        	// because getElementByTagName returns even nested sub elements
        	if( isNotDirectChild( node, attributeList.item(attributeListIndex)))
        		continue;
        	
    		NodeList attributeStringList = ((Element)attributeList.item(attributeListIndex)).getElementsByTagName( "string");
        	for (int attributeStringListIndex = 0; attributeStringListIndex < attributeStringList.getLength(); attributeStringListIndex++) {
        		newEarnixStruct.addAttributeKey( ((Element)attributeStringList.item(attributeStringListIndex)).getTextContent());
        		System.out.println( "Add new Attribute: " + ((Element)attributeStringList.item(attributeStringListIndex)).getTextContent());
        	}
        }
        
		// parse subitems
		NodeList subitemList = ((Element)node).getElementsByTagName( "subItems");
		for (int subitemListIndex = 0; subitemListIndex < subitemList.getLength(); subitemListIndex++) {
        	// because getElementByTagName returns even nested sub elements
        	if( isNotDirectChild( node, subitemList.item(subitemListIndex)))
        		continue;

    		NodeList subitemSchemaList = ((Element)subitemList.item(subitemListIndex)).getElementsByTagName( "SchemaV6");
    		
        	for (int subitemSchemaListIndex = 0; subitemSchemaListIndex < subitemSchemaList.getLength(); subitemSchemaListIndex++) {
            	if( isNotDirectChild( subitemList.item(subitemListIndex), subitemSchemaList.item(subitemSchemaListIndex)))
            		continue;

            	parseEarnixInputAttributesRecursive( subitemSchemaList.item(subitemSchemaListIndex), newEarnixStruct);
        	}
        }
	}

	private void parseStruktury(Node item) {
		Struktura novaStruktura = new Struktura( 1, 1, 0);
		for( int index = 0; index < item.getChildNodes().getLength(); index++)
        {
        	Node node = item.getChildNodes().item(index);
        	if (node.getNodeType() != Node.ELEMENT_NODE)
        		continue;
          	  
        	Element element = (Element) node;
        	System.out.println( element.getNodeName() + " - " + element.getTextContent());

        	if( element.getNodeName() == "ns5:id") {
        		novaStruktura.setId( Integer.valueOf( element.getTextContent()));
        	}
        	else if( element.getNodeName() == "ns5:poradiStruktury") {
        		novaStruktura.setPoradiStruktury( Integer.valueOf( element.getTextContent()));
        	}else if( element.getNodeName() == "ns5:poradiNadrazeneStruktury") {
        		novaStruktura.setPoradiNadrazeneStruktury( Integer.valueOf( element.getTextContent()));
        	}
        }

		BalickyDataNode newNode = new BalickyDataNode( novaStruktura);
		structMap.put( novaStruktura.getPoradiStruktury(), newNode);

		if( novaStruktura.getPoradiStruktury() == 1)
		{
			return;
		}

		BalickyDataNode parentNode = structMap.get( novaStruktura.getPoradiNadrazeneStruktury());
		if( parentNode == null)
		{
			System.out.println( "ERR - Neexistujici parent skupina " + 2);
			return;
		}
		
		parentNode.addChild( newNode);
	}

	private void parsePole(Node item) {
		Pole novePole = new Pole( 0, 0, 0, false, "");
		for( int index = 0; index < item.getChildNodes().getLength(); index++)
        {
        	Node node = item.getChildNodes().item(index);
        	if (node.getNodeType() != Node.ELEMENT_NODE)
        		continue;
          	  
        	Element element = (Element) node;
        	System.out.println( element.getNodeName() + " - " + element.getTextContent());
        	if( element.getNodeName() == "ns5:cisloPole") {
        		novePole.setPoleId( Integer.valueOf( element.getTextContent()));
        	}
        	else if( element.getNodeName() == "ns5:poradiStruktury")
        		novePole.setStructId( Integer.valueOf( element.getTextContent()));
        	else if( element.getNodeName() == "ns5:vstupProBalicky")
        		novePole.setBalickyInput( element.getTextContent()=="true"?true:false);
        	else if( element.getNodeName().contains( "ns5:hodnota"))
        		novePole.setValue( element.getTextContent());
        		
        }

		BalickyDataNode newNode = new BalickyDataNode( novePole);
		BalickyDataNode parentNode = structMap.get( novePole.getStructId());
		
//		BalickyDataNode parentNode = structMap.get( 1);
		if( parentNode == null)
		{
			// TODO zahlas chybu
			return;
		}
		
		parentNode.addChild( newNode);
	}


}
