package TreeTable;

import EarnixParser.EarnixAttribute;
import EarnixParser.EarnixStruct;

public class EarnixTreeTableDataModel extends MyAbstractTreeTableModel {
    static protected String[] columnNames = { "NZEV", "HODNOTA" };
    static protected Class<?>[] columnTypes = { MyTreeTableModel.class, String.class, String.class, String.class};
 
    public EarnixTreeTableDataModel(EarnixStruct rootNode) {
        super(rootNode);
        root = rootNode;
    }
 
    public Object getChild(Object parent, int index) {
    	// if index < count of attributes return appropriate attribute, else return subitem
    	EarnixStruct castedParent = (EarnixStruct) parent;
    	if( index < castedParent.getAttributeCount())
    		return castedParent.getAttributeList().get(index);
    	else
    		return castedParent.getSubItems().get(index - castedParent.getAttributeCount());
    }
 
    public int getChildCount(Object parent) {
    	// if parent is EarnixStruct return numberOfAttributes+numberOfChildEarnixStruct
    	if( parent instanceof EarnixStruct)
    		return ((EarnixStruct) parent).getAttributeCount() + ((EarnixStruct) parent).getSubItems().size();
    	
    	return 0;
    }
 
 
    public int getColumnCount() {
        return columnNames.length;
    }
 
 
    public String getColumnName(int column) {
        return columnNames[column];
    }
 
 
    public Class<?> getColumnClass(int column) {
        return columnTypes[column];
    }
 
    public Object getValueAt(Object node, int column) {
    	if( node instanceof EarnixStruct)
    	{
    		EarnixStruct struktura = (EarnixStruct)node;
            switch (column) {
            	case 0:
            		return struktura;
            	case 1:
            		return struktura.getPath();
            	default:
            	break;
            }
    		
    	}
    	else if( node instanceof EarnixAttribute)
    	{
    		EarnixAttribute struktura = (EarnixAttribute)node;
            switch (column) {
        		case 0:
        			return struktura;
        		case 1:
        			return struktura.getValue();
        		default:
        		break;
            }
    	}
		return "ERROR";
    }
 
    public boolean isCellEditable(Object node, int column) {
        return true; // Important to activate TreeExpandListener
    }
 
    public void setValueAt(Object aValue, Object node, int column) {
    }
 
}