package TreeTable;

import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class MyTreeTable extends JTable {
	 
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private MyTreeTableCellRenderer tree;
 
 
    public MyTreeTable(MyAbstractTreeTableModel treeTableModel) {
        super();
 
        tree = new MyTreeTableCellRenderer(this, treeTableModel);
 
        super.setModel(new MyTreeTableModelAdapter(treeTableModel, tree));
 
        MyTreeTableSelectionModel selectionModel = new MyTreeTableSelectionModel();
        tree.setSelectionModel(selectionModel); //For the tree
        setSelectionModel(selectionModel.getListSelectionModel()); //For the table
 
 
        setDefaultRenderer(MyTreeTableModel.class, tree);
        setDefaultEditor(MyTreeTableModel.class, new MyTreeTableCellEditor(tree, this));
        
 
        setShowGrid(false);
 
        setIntercellSpacing(new Dimension(0, 0));
    }
    
    public MyTreeTableCellRenderer getTree() {
    	return tree;
    }
    
    public void setModel( MyAbstractTreeTableModel treeTableModel)
    {
        tree = new MyTreeTableCellRenderer(this, treeTableModel);
    	setModel(new MyTreeTableModelAdapter(treeTableModel, tree));

        MyTreeTableSelectionModel selectionModel = new MyTreeTableSelectionModel();
        tree.setSelectionModel(selectionModel); //For the tree
        setSelectionModel(selectionModel.getListSelectionModel()); //For the table
 
        setDefaultRenderer(MyTreeTableModel.class, tree);
        setDefaultEditor(MyTreeTableModel.class, new MyTreeTableCellEditor(tree, this));
 
        setShowGrid(false);
 
        setIntercellSpacing(new Dimension(0, 0));

        expandAll();
        tree.addTreeSelectionListener( new TreeSelectionListener() {
			@Override
			public void valueChanged(TreeSelectionEvent e) {
				System.out.println( e.getPath().toString());
			}
        	
        });
    }

	public void expandAll() {
    	int row1 = 0;
        while (row1++ < getRowCount()){
            tree.expandRow(row1);
        }
	}
}